<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/header.php';

$db = get_db();

// Simple stats
$totalClients = $db->query('SELECT COUNT(*) AS c FROM clients')->fetch()['c'] ?? 0;
$totalInvoices = $db->query('SELECT COUNT(*) AS c FROM invoices')->fetch()['c'] ?? 0;
$totalLaybys = $db->query('SELECT COUNT(*) AS c FROM laybys')->fetch()['c'] ?? 0;
?>
<h2>Dashboard</h2>

<p>Welcome, <?php echo htmlspecialchars($_SESSION['user']['name']); ?>.</p>

<ul>
    <li>Total clients: <strong><?php echo $totalClients; ?></strong></li>
    <li>Total invoices: <strong><?php echo $totalInvoices; ?></strong></li>
    <li>Total lay-bys: <strong><?php echo $totalLaybys; ?></strong></li>
</ul>

<p>
    <a class="btn" href="clients.php">Manage Clients</a>
    <a class="btn" href="laybys.php">Manage Lay-Bys</a>
</p>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
